﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using UnityEngine.UI; //kada koristimo text za prikazivanje skora 
//posto smo koristili objekat tipa UI
public enum ColorUsed
{
    Red,
    Yellow,
    Green,
    Blue,
    Purple
}
public class MenagerReferences : MonoBehaviour
{
    // ovde se dodaje brojac za poene tj zvezde 
    //jer je lakse da menadzer upravlja sa tim osnovnim stvarima
    //svi mogu da mu pristupe 
    public GameObject ball;
    public Color[] Colors;
    public int score ;
    public Text scoreText;
   
    void Start () {
        score = 0;
       
    }
	
	// Update is called once per frame
	void Update () {
		
	}

    public void IncreaseScore(int amount)
    {
        score += amount;
        scoreText.text = score.ToString();
  
    }

    
    public void SwitchPlayerColor(ColorUsed newColor)
    {
        SpriteRenderer  renderer = ball.GetComponent<SpriteRenderer>();
        switch(newColor)
        { // ovde uzima vrednosti iz niza boja koje smo dodali u menagera -tim redom
            case ColorUsed.Red:
                renderer.color = Colors[0];
                break;
           case ColorUsed.Yellow:
                renderer.color = Colors[1];
                break;
            case ColorUsed.Green:
                renderer.color = Colors[2];
                break;
            case ColorUsed.Blue:
                renderer.color = Colors[3];
                break;
            case ColorUsed.Purple:
                renderer.color = Colors[4];
                break;
            default:
                renderer.color = Colors[0];
                break;
        }     
    }
    
    public void ShowRestartPanel()
    {
       PlayerPrefs.SetInt("FinalScore", score);
       Application.LoadLevel("Restart");
       
    }

   

}
